'# MWS Version: Version 2013.2 - Jul 03 2013 - ACIS 23.0.0 -

'# length = mm
'# frequency = GHz
'# time = ns
'# frequency range: fmin = 0.0 fmax = 0.0


'@ use template: Antenna (Horn, Waveguide)

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
' Template for Antenna in Free Space
' ==================================
' (CSTxMWSxONLY)
' draw the bounding box
Plot.DrawBox True
' set units to mm, ghz
With Units 
     .Geometry "mm" 
     .Frequency "ghz" 
     .Time "ns" 
End With 
' set background material to vacuum
With Background 
     .Type "Normal" 
     .Epsilon "1.0" 
     .Mue "1.0" 
     .XminSpace "0.0" 
     .XmaxSpace "0.0" 
     .YminSpace "0.0" 
     .YmaxSpace "0.0" 
     .ZminSpace "0.0" 
     .ZmaxSpace "0.0" 
End With 
' set boundary conditions to open
With Boundary
     .Xmin "expanded open" 
     .Xmax "expanded open" 
     .Ymin "expanded open" 
     .Ymax "expanded open" 
     .Zmin "expanded open" 
     .Zmax "expanded open" 
     .Xsymmetry "none" 
     .Ysymmetry "none" 
     .Zsymmetry "none" 
End With
' switch on FD-TET setting for accurate farfields
FDSolver.ExtrudeOpenBC "True" 
Mesh.FPBAAvoidNonRegUnite "True" 
Mesh.ConsiderSpaceForLowerMeshLimit "False" 
Mesh.MinimumStepNumber "5"

'@ define curve analytical: curve1:Parabola

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
With AnalyticalCurve
     .Reset 
     .Name "Parabola" 
     .Curve "curve1" 
     .LawX "0" 
     .LawY "t" 
     .LawZ "t^2/4/F" 
     .ParameterRange "0", "D/2" 
     .Create
End With

'@ define curve circle: curve1:Circulo

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
With Circle
     .Reset 
     .Name "Circulo" 
     .Curve "curve1" 
     .Radius "D/2" 
     .Xcenter "0.0" 
     .Ycenter "0.0" 
     .Segments "0" 
     .Create
End With

'@ new component: Antena

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
Component.New "Antena"

'@ define sweepprofile: Antena:FocoCentrado

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
With SweepCurve
     .Reset 
     .Name "FocoCentrado" 
     .Component "Antena" 
     .Material "Vacuum" 
     .Twistangle "0.0" 
     .Taperangle "0.0" 
     .ProjectProfileToPathAdvanced "False" 
     .Path "curve1:Circulo" 
     .Curve "curve1:Parabola" 
     .Create
End With

'@ define cylinder: Antena:Offset

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
With Cylinder 
     .Reset 
     .Name "Offset" 
     .Component "Antena" 
     .Material "PEC" 
     .OuterRadius "ODX/2" 
     .InnerRadius "0.0" 
     .Axis "z" 
     .Zrange "-100", "1000" 
     .Xcenter "0" 
     .Ycenter "ODX/2+OFC" 
     .Segments "0" 
     .Create 
End With

'@ boolean intersect shapes: Antena:Offset, Antena:FocoCentrado

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
With Solid 
     .Version 9
     .Intersect "Antena:Offset", "Antena:FocoCentrado" 
     .Version 1
End With

'@ transform: rotate Antena

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
With Transform 
     .Reset 
     .Name "Antena" 
     .Origin "Free" 
     .Center "0", "0", "F" 
     .Angle "-Ang", "0", "0" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Shape", "Rotate" 
End With

'@ transform: translate Antena

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
With Transform 
     .Reset 
     .Name "Antena" 
     .Vector "0", "0", "-DistFocal" 
     .UsePickedPoints "False" 
     .InvertPickedPoints "False" 
     .MultipleObjects "False" 
     .GroupObjects "False" 
     .Repetitions "1" 
     .MultipleSelection "False" 
     .Transform "Shape", "Translate" 
End With

'@ pick point

'[VERSION]2011.7|21.0.0|20111130[/VERSION]
Pick.PickPointFromCoordinates "0", "0", "0"

'@ set mesh properties

'[VERSION]2013.2|23.0.0|20130703[/VERSION]
With MeshSettings 
     .SetMeshType "Tet" 
     .Set "CellsPerWavelengthPolicy", "cellsperwavelength" 
     .Set "CurvatureOrderPolicy", "off" 
     .SetMeshType "Plane" 
     .Set "CurvatureOrderPolicy", "off" 
End With

